/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.bungee;

import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.api.plugin.Plugin;
import net.skinsrestorer.api.PlayerWrapper;
import net.skinsrestorer.api.SkinsRestorerAPI;
import net.skinsrestorer.api.exception.SkinRequestException;
import net.skinsrestorer.api.interfaces.IPropertyFactory;
import net.skinsrestorer.api.interfaces.ISRPlayer;
import net.skinsrestorer.api.interfaces.ISRProxyPlayer;
import net.skinsrestorer.api.property.IProperty;
import net.skinsrestorer.api.reflection.ReflectionUtil;
import net.skinsrestorer.bungee.BungeePropertyNew;
import net.skinsrestorer.bungee.BungeePropertyOld;
import net.skinsrestorer.bungee.SkinApplierBungeeNew;
import net.skinsrestorer.bungee.SkinApplierBungeeOld;
import net.skinsrestorer.bungee.SkinApplierBungeeShared;
import net.skinsrestorer.bungee.commands.GUICommand;
import net.skinsrestorer.bungee.commands.SkinCommand;
import net.skinsrestorer.bungee.commands.SrCommand;
import net.skinsrestorer.bungee.listeners.ConnectListener;
import net.skinsrestorer.bungee.listeners.LoginListener;
import net.skinsrestorer.bungee.listeners.PluginMessageListener;
import net.skinsrestorer.bungee.utils.BungeeConsoleImpl;
import net.skinsrestorer.bungee.utils.WrapperBungee;
import net.skinsrestorer.shadow.aikar.commands.BungeeCommandManager;
import net.skinsrestorer.shadow.bstats.bungeecord.Metrics;
import net.skinsrestorer.shadow.bstats.charts.SingleLineChart;
import net.skinsrestorer.shadow.spiget.UpdateCallback;
import net.skinsrestorer.shared.interfaces.ISRPlugin;
import net.skinsrestorer.shared.interfaces.ISRProxyPlugin;
import net.skinsrestorer.shared.storage.Config;
import net.skinsrestorer.shared.storage.Locale;
import net.skinsrestorer.shared.storage.SkinStorage;
import net.skinsrestorer.shared.update.UpdateChecker;
import net.skinsrestorer.shared.update.UpdateCheckerGitHub;
import net.skinsrestorer.shared.utils.MetricsCounter;
import net.skinsrestorer.shared.utils.SharedMethods;
import net.skinsrestorer.shared.utils.WrapperFactory;
import net.skinsrestorer.shared.utils.connections.MineSkinAPI;
import net.skinsrestorer.shared.utils.connections.MojangAPI;
import net.skinsrestorer.shared.utils.log.JavaLoggerImpl;
import net.skinsrestorer.shared.utils.log.SRLogger;

public class SkinsRestorer
extends Plugin
implements ISRProxyPlugin {
    private static final String NEW_PROPERTY_CLASS = "net.md_5.bungee.protocol.Property";
    private final MetricsCounter metricsCounter = new MetricsCounter();
    private final BungeeConsoleImpl bungeeConsole = new BungeeConsoleImpl(this.getProxy() == null ? null : this.getProxy().getConsole());
    private final JavaLoggerImpl javaLogger = new JavaLoggerImpl(this.bungeeConsole, this.getProxy() == null ? null : this.getProxy().getLogger());
    private final SRLogger srLogger = new SRLogger(this.javaLogger, true);
    private final MojangAPI mojangAPI = new MojangAPI(this.srLogger, this.metricsCounter);
    private final MineSkinAPI mineSkinAPI = new MineSkinAPI(this.srLogger, this.metricsCounter);
    private final SkinStorage skinStorage = new SkinStorage(this.srLogger, this.mojangAPI, this.mineSkinAPI);
    private final SkinApplierBungeeShared skinApplierBungee = SkinsRestorer.selectSkinApplier(this, this.srLogger);
    private final SkinsRestorerAPI skinsRestorerAPI = new SkinsRestorerBungeeAPI();
    private final SkinCommand skinCommand = new SkinCommand(this);
    private Path dataFolderPath;
    private boolean outdated;
    private UpdateChecker updateChecker;
    private BungeeCommandManager manager;

    private static SkinApplierBungeeShared selectSkinApplier(ISRPlugin plugin, SRLogger srLogger) {
        if (ReflectionUtil.classExists(NEW_PROPERTY_CLASS)) {
            return new SkinApplierBungeeNew(plugin, srLogger);
        }
        return new SkinApplierBungeeOld(plugin, srLogger);
    }

    @Override
    public String getVersion() {
        return this.getDescription().getVersion();
    }

    public void onEnable() {
        this.bungeeConsole.setCommandSender(this.getProxy().getConsole());
        this.javaLogger.setLogger(this.getProxy().getLogger());
        this.dataFolderPath = this.getDataFolder().toPath();
        this.srLogger.load(this.dataFolderPath);
        Path updaterDisabled = this.dataFolderPath.resolve("noupdate.txt");
        Metrics metrics = new Metrics(this, 1686);
        metrics.addCustomChart(new SingleLineChart("mineskin_calls", this.metricsCounter::collectMineskinCalls));
        metrics.addCustomChart(new SingleLineChart("minetools_calls", this.metricsCounter::collectMinetoolsCalls));
        metrics.addCustomChart(new SingleLineChart("mojang_calls", this.metricsCounter::collectMojangCalls));
        metrics.addCustomChart(new SingleLineChart("ashcon_calls", this.metricsCounter::collectAshconCalls));
        if (!Files.exists(updaterDisabled, new LinkOption[0])) {
            this.updateChecker = new UpdateCheckerGitHub(2124, this.getDescription().getVersion(), this.srLogger, "SkinsRestorerUpdater/BungeeCord");
            this.checkUpdate(true);
            Random rn = new Random();
            int delayInt = 60 + rn.nextInt(181);
            this.getProxy().getScheduler().schedule((Plugin)this, this::checkUpdate, (long)delayInt, (long)delayInt, TimeUnit.MINUTES);
        } else {
            this.srLogger.info("Updater Disabled");
        }
        Config.load(this.dataFolderPath, this.getResource("config.yml"), this.srLogger);
        Locale.load(this.dataFolderPath, this.srLogger);
        if (!this.initStorage()) {
            return;
        }
        this.getProxy().getPluginManager().registerListener((Plugin)this, (Listener)new LoginListener(this));
        this.getProxy().getPluginManager().registerListener((Plugin)this, (Listener)new ConnectListener(this));
        this.initCommands();
        this.getProxy().registerChannel("sr:skinchange");
        this.getProxy().registerChannel("sr:messagechannel");
        this.getProxy().getPluginManager().registerListener((Plugin)this, (Listener)new PluginMessageListener(this));
        this.getProxy().getScheduler().runAsync((Plugin)this, () -> SharedMethods.runServiceCheck(this.mojangAPI, this.srLogger));
    }

    private void initCommands() {
        this.manager = new BungeeCommandManager(this);
        this.prepareACF(this.manager, this.srLogger);
        this.manager.registerCommand(this.skinCommand);
        this.manager.registerCommand(new SrCommand(this));
        this.manager.registerCommand(new GUICommand(this));
    }

    private boolean initStorage() {
        if (!SharedMethods.initStorage(this.srLogger, this.skinStorage, this.dataFolderPath)) {
            this.getProxy().getPluginManager().unregisterListeners((Plugin)this);
            this.getProxy().getPluginManager().unregisterCommands((Plugin)this);
            return false;
        }
        ProxyServer.getInstance().getScheduler().runAsync((Plugin)this, this.skinStorage::preloadDefaultSkins);
        return true;
    }

    private void checkUpdate() {
        this.checkUpdate(false);
    }

    private void checkUpdate(final boolean showUpToDate) {
        ProxyServer.getInstance().getScheduler().runAsync((Plugin)this, () -> this.updateChecker.checkForUpdate(new UpdateCallback(){

            @Override
            public void updateAvailable(String newVersion, String downloadUrl, boolean hasDirectDownload) {
                SkinsRestorer.this.outdated = true;
                SkinsRestorer.this.updateChecker.getUpdateAvailableMessages(newVersion, downloadUrl, hasDirectDownload, SkinsRestorer.this.getVersion(), false).forEach(SkinsRestorer.this.srLogger::info);
            }

            @Override
            public void upToDate() {
                if (!showUpToDate) {
                    return;
                }
                SkinsRestorer.this.updateChecker.getUpToDateMessages(SkinsRestorer.this.getVersion(), false).forEach(SkinsRestorer.this.srLogger::info);
            }
        }));
    }

    @Override
    public InputStream getResource(String resource) {
        return this.getClass().getClassLoader().getResourceAsStream(resource);
    }

    @Override
    public void runAsync(Runnable runnable) {
        this.getProxy().getScheduler().runAsync((Plugin)this, runnable);
    }

    @Override
    public Collection<ISRPlayer> getOnlinePlayers() {
        return this.getProxy().getPlayers().stream().map(WrapperBungee::wrapPlayer).collect(Collectors.toList());
    }

    @Override
    public Optional<ISRProxyPlayer> getPlayer(String playerName) {
        return Optional.ofNullable(this.getProxy().getPlayer(playerName)).map(WrapperBungee::wrapPlayer);
    }

    @Override
    public MetricsCounter getMetricsCounter() {
        return this.metricsCounter;
    }

    public BungeeConsoleImpl getBungeeConsole() {
        return this.bungeeConsole;
    }

    public JavaLoggerImpl getJavaLogger() {
        return this.javaLogger;
    }

    @Override
    public SRLogger getSrLogger() {
        return this.srLogger;
    }

    @Override
    public MojangAPI getMojangAPI() {
        return this.mojangAPI;
    }

    public MineSkinAPI getMineSkinAPI() {
        return this.mineSkinAPI;
    }

    @Override
    public SkinStorage getSkinStorage() {
        return this.skinStorage;
    }

    public SkinApplierBungeeShared getSkinApplierBungee() {
        return this.skinApplierBungee;
    }

    public SkinsRestorerAPI getSkinsRestorerAPI() {
        return this.skinsRestorerAPI;
    }

    @Override
    public SkinCommand getSkinCommand() {
        return this.skinCommand;
    }

    @Override
    public Path getDataFolderPath() {
        return this.dataFolderPath;
    }

    public boolean isOutdated() {
        return this.outdated;
    }

    public UpdateChecker getUpdateChecker() {
        return this.updateChecker;
    }

    public BungeeCommandManager getManager() {
        return this.manager;
    }

    private class SkinsRestorerBungeeAPI
    extends SkinsRestorerAPI {
        public SkinsRestorerBungeeAPI() {
            super(SkinsRestorer.this.mojangAPI, SkinsRestorer.this.mineSkinAPI, SkinsRestorer.this.skinStorage, new WrapperFactoryBungee(), new PropertyFactoryBungee());
        }

        @Override
        public void applySkin(PlayerWrapper playerWrapper) throws SkinRequestException {
            this.applySkin(playerWrapper, playerWrapper.get(ProxiedPlayer.class).getName());
        }

        @Override
        public void applySkin(PlayerWrapper playerWrapper, String playerName) throws SkinRequestException {
            this.applySkin(playerWrapper, SkinsRestorer.this.skinStorage.getSkinForPlayer(playerName));
        }

        @Override
        public void applySkin(PlayerWrapper playerWrapper, IProperty property) {
            SkinsRestorer.this.skinApplierBungee.applySkin(playerWrapper.get(ProxiedPlayer.class), property);
        }
    }

    private static class PropertyFactoryBungee
    implements IPropertyFactory {
        private PropertyFactoryBungee() {
        }

        @Override
        public IProperty createProperty(String name, String value, String signature) {
            if (ReflectionUtil.classExists(SkinsRestorer.NEW_PROPERTY_CLASS)) {
                return new BungeePropertyNew(name, value, signature);
            }
            return new BungeePropertyOld(name, value, signature);
        }
    }

    private static class WrapperFactoryBungee
    extends WrapperFactory {
        private WrapperFactoryBungee() {
        }

        @Override
        public ISRPlayer wrapPlayer(Object playerInstance) {
            if (playerInstance instanceof ProxiedPlayer) {
                ProxiedPlayer player = (ProxiedPlayer)playerInstance;
                return WrapperBungee.wrapPlayer(player);
            }
            throw new IllegalArgumentException("Player instance is not valid!");
        }
    }
}

